//////////////////////
// Basic Stream I/O //
//////////////////////

#include "Basic IO.h"
#include <string.h>

const char * strustr (const char *string, const char *substring)
{
    static char temp [2000];
    return strstr (strupr (strcpy (temp, string)), substring);
}

void ReadRect (istream& stream, RECT& rect)
{
	stream >> rect.left;
	stream >> rect.top;
	stream >> rect.right;
	stream >> rect.bottom;
}

void WriteRect (ostream& stream, const RECT& rect)
{
	stream << rect.left << ' ';
	stream << rect.top << ' ';
	stream << rect.right << ' ';
	stream << rect.bottom << ' ';
}

void SkipToDelim (istream& stream)
{
	char ch;

	stream.unsetf (ios::skipws);

	do
		stream >> ch;
	while (stream && (ch != DELIM));
	stream.setf (ios::skipws);
}

void ReadToDelim (istream& stream, char *text)
{
	char ch;

	stream.unsetf (ios::skipws);

	stream >> ch;

	while (stream && (ch != DELIM)) {
		*text++ = ch;
		stream >> ch;
	}

	*text = NULL;
	stream.setf (ios::skipws);
}